---
tags: ux programming sleep cognition
---

Sensitivity to brightness can occur due to number of issues ranging from corneal issues like infections and abrasions, to dry eye, to concussions, to allergies; eg: Keratoconus, Uveitis, Keratitis, Preeclampsia. Google claims in its [[android developer guide that dark themes can improve visibility for people who have low vision and are sensititive to brightness::https://developer.android.com/guide/topics/ui/look-and-feel/darktheme]], but people I have spoken to on this topic (n≈20) had normal vision and normal range of sensitivity to light.

Even people with mild eye issues[[Jason Harrison, UBC - People with astigmatism (approximately 50% of the population) find it harder to read white text on black than black text on white.::lsn]] seem to benefit from light theme than dark theme in most cases. And to top it all, even the researches that focus on the legibility[[Bauer, D., & Cavonius, C., R. (1980). *Improving the legibility of visual display units through contrast reversal.* <br/>**See Below for more**.::rsn]] and aesthetics claim that dark on light is almost always better than dark on light. Every article I have read and referenced below vouch for dark on light, which I find to be true too at least in most occasions.

How can what is relatively bad for legibility in most ocassions, bad in terms of expressibility of authorial aesthetics be a wide-spread preference? My hypothesis is this is primarily due to cognitive exhaustion like sleep deprivation, burn-out, stress etc (Extrapolating from n=1), which due to implicity conformity and [[preference falsification::https://en.wikipedia.org/wiki/Preference_falsification]] has become a normative social element. My experience has been that when I have had a bad last night sleep or stress due to office, I invariably am looking for less polarity, otherwise the dark on white seems more appealing to me both aesthetics wise and legibility wise. An extension of these could be that cognitive stress elevate the ocular stress like accomodative/refractive/convergence stress leading up to this, but I contest dark mode being the wide-spread personal/subjective preference.

---

## References

Bauer, D., & Cavonius, C., R. (1980). _Improving the legibility of visual display units through contrast reversal._
(From: [[UX Stackexchange on theme and eye strain::https://ux.stackexchange.com/questions/53264/dark-or-white-color-theme-is-better-for-the-eyes]])

> "...However, most studies have shown that dark characters on a light background are superior to light characters on a dark background (when the refresh rate is fairly high). For example, Bauer and Cavonius (1980) found that participants were 26% more accurate in reading text when they read it with dark characters on a light background..."

Pabini Gabriel-Petit. (2007). _[[Applying color theory to digital displays::https://www.uxmatters.com/mt/archives/2007/01/applying-color-theory-to-digital-displays.php]]_

> "...While white text on a black background provides very high value contrast, it is less readable and causes greater eye fatigue than black text on a white background..."

Jason Harrison – Post Doctoral Fellow, Imager Lab Manager – Sensory Perception and Interaction Research Group, University of British Columbia

> People with astigmatism (approximately 50% of the population) find it harder to read white text on black than black text on white. Part of this has to do with light levels: with a bright display (white background) the iris closes a bit more, decreasing the effect of the "deformed" lens; with a dark display (black background) the iris opens to receive more light and the deformation of the lens creates a much fuzzier focus at the eye.

Raluca Budiu. (2020). _[[Dark mode v Light Mode: Which is better::https://www.nngroup.com/articles/dark-mode/]]_

> "...Their results showed that light mode won across all dimensions: irrespective of age, the positive contrast polarity was better for both visual-acuity tasks and for proofreading tasks. However, the difference between light mode and dark mode in the visual-acuity task was smaller for older adults than for younger adults — meaning that, although light mode was better for older adults, too, they did not benefit from it as much as younger adults, at least in the visual-acuity task.
>
> When researchers looked at fatigue metrics, they concluded that there was no significant difference of contrast polarity on any of them (meaning that it wasn’t the case that dark mode made people more tired, or vice versa)..."

Lauren V. Scharff, Albert J Ahumada. (2005). [[Why is light text harder to read than dark text::https://jov.arvojournals.org/article.aspx?articleid=2132608]]

> "...For paragraph readability and letter identification, responses to light text were slower and less accurate for a given contrast...."

Jim Sheedy, Kevin Larson. (2008). _[[Blink: The stress of Reading::https://www.eyemagazine.com/opinion/article/eye-strain]]_
